SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL';

CREATE SCHEMA IF NOT EXISTS `offreStage` DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci ;
USE `offreStage` ;

-- -----------------------------------------------------
-- Table `offreStage`.`Param`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `offreStage`.`Param` (
  `idParam` INT NOT NULL COMMENT 'Identifiant du paramètre.' ,
  `categorie` VARCHAR(128) NOT NULL COMMENT 'Catégorie du paramètre : entreprise, contact, devise, ...' ,
  `valeur` VARCHAR(128) NOT NULL COMMENT 'Valeur du paramètre : type d\'entreprise, type de contact, devise, ...' ,
  `description` VARCHAR(256) NULL COMMENT 'Description du paramètre.' ,
  PRIMARY KEY (`idParam`) )
ENGINE = InnoDB, 
COMMENT = 'Liste des paramètres de la base de données.' ;


-- -----------------------------------------------------
-- Table `offreStage`.`Offre`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `offreStage`.`Offre` (
  `idOffre` INT NOT NULL ,
  `dateDepot` DATE NOT NULL COMMENT 'Date de dépôt de l\'offre.' ,
  `annee` INT NOT NULL COMMENT 'Année de l\'offre de stage (année durant laquelle le stage doit être effectué).' ,
  `titre` VARCHAR(64) NOT NULL COMMENT 'Titre de l\'offre de stage.' ,
  `description` VARCHAR(512) NOT NULL COMMENT 'Description de l\'offre de stage.' ,
  `realisation` VARCHAR(512) NOT NULL COMMENT 'Travail à realiser.' ,
  `dateDebut` DATE NOT NULL COMMENT 'Date de début du stage.' ,
  `duree` VARCHAR(128) NOT NULL COMMENT 'Durée enivasgée du stage. (\"4 mois\", \"20 semaines\", ...).' ,
  `dureeHebdomadaire` VARCHAR(128) NULL COMMENT 'Durée hebdomadaire de présence (35h).' ,
  `horaires` VARCHAR(128) NULL COMMENT 'Horaires de présence(9h-12h; 14h-18h).' ,
  `remuneration` FLOAT NULL COMMENT 'Rémunération (en fonction de la devise choisie).' ,
  `idDevise` INT NULL COMMENT 'Identifiant de la devise utilisée pour la rémunération du stage.' ,
  `avantages` VARCHAR(256) NULL COMMENT 'Avantages (tickets resto, etc...).' ,
  `laboratoire` TINYINT(1)  NOT NULL COMMENT 'Stage en laboratoire ou centre de recherche ?' ,
  `prioritaire` TINYINT(1)  NOT NULL COMMENT 'Stage prioritaire (offre spécialement pour l\'ISIMA ou venant d\'un ancien ZZ) ?' ,
  `disponible` TINYINT(1)  NOT NULL COMMENT 'Offre de stage encore disponible ?' ,
  `dateFinDepot` DATE NULL COMMENT 'Date de fin de dépôt.' ,
  `raisonFinDepot` VARCHAR(256) NULL COMMENT 'Raison de fin de dépôt de l\'offre (stage pourvu, abandon du sujet par l\'entreprise, etc...).' ,
  `nombreSalaries` INT NULL COMMENT 'Nombre de salariés du lieu du stage (si différent du lieu de l\'entreprise).' ,
  `adresse` VARCHAR(256) NULL COMMENT 'Adresse du stage (si différente de celle l\'entreprise).' ,
  `niveau` VARCHAR(256) NULL COMMENT 'Niveau envisagé pour le stage (deuxième année, troisième année, etc...).' ,
  `profil` VARCHAR(256) NULL COMMENT 'Profil envisagé (développement, F4, etc...).' ,
  `service` VARCHAR(128) NULL COMMENT 'Service de l\'entreprise où aura lieu le stage.' ,
  `remarques` VARCHAR(256) NULL COMMENT 'Remarques.' ,
  PRIMARY KEY (`idOffre`) ,
  INDEX `idDevise` (`idDevise` ASC) ,
  CONSTRAINT `idDevise`
    FOREIGN KEY (`idDevise` )
    REFERENCES `offreStage`.`Param` (`idParam` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB
COMMENT = 'Liste des offres de stage.' ;


-- -----------------------------------------------------
-- Table `offreStage`.`Groupe`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `offreStage`.`Groupe` (
  `idGroupe` INT NOT NULL COMMENT 'Identifiant du groupe.' ,
  `nom` VARCHAR(64) NOT NULL COMMENT 'Nom du groupe.' ,
  `adresse` VARCHAR(256) NOT NULL COMMENT 'Adrresse du siège social du groupe.' ,
  `codePostal` VARCHAR(32) NOT NULL COMMENT 'Code postal du groupe.' ,
  `ville` VARCHAR(64) NOT NULL COMMENT 'Ville.' ,
  `siteWeb` VARCHAR(128) NULL COMMENT 'Site Web du groupe.' ,
  `description` VARCHAR(256) NULL COMMENT 'Description du groupe.' ,
  `nombreSalaries` INT NULL COMMENT 'Nombre de salariés du groupe.' ,
  `type` VARCHAR(128) NULL COMMENT 'Type du groupe (Société de service, Industrie, ...).' ,
  `domaine` VARCHAR(128) NULL COMMENT 'Domaine du groupe (pneumatique, dévelopemment, conseil, ...).' ,
  `remarques` VARCHAR(256) NULL COMMENT 'Remarques.' ,
  PRIMARY KEY (`idGroupe`) )
ENGINE = InnoDB, 
COMMENT = 'Liste des groupes offrant des offres de stage.' ;


-- -----------------------------------------------------
-- Table `offreStage`.`Entreprise`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `offreStage`.`Entreprise` (
  `idEntreprise` INT NOT NULL ,
  `idGroupe` INT NULL COMMENT 'Identifiant du groupe associé à l\'entreprise (optionnel).' ,
  `nom` VARCHAR(64) NOT NULL COMMENT 'Nom de l\'entreprise.' ,
  `adresse` VARCHAR(256) NOT NULL COMMENT 'Adresse du siège de l\'entreprise.' ,
  `codePostal` VARCHAR(32) NOT NULL COMMENT 'Code postal.' ,
  `ville` VARCHAR(64) NOT NULL COMMENT 'Ville.' ,
  `codeAPENAF` VARCHAR(32) NULL COMMENT 'Code APE/NAF.' ,
  `siteWeb` VARCHAR(128) NULL COMMENT 'Site Web' ,
  `description` VARCHAR(256) NULL COMMENT 'Description de l\'entreprise.' ,
  `nombreSalaries` INT NULL COMMENT 'Nombre de salariés de l\'entreprise.' ,
  `type` VARCHAR(128) NULL COMMENT 'Type de l\'entreprise (Industrie, SSII, ...).' ,
  `domaine` VARCHAR(128) NULL COMMENT 'Domaine de l\'entreprise (Pneumatique, dévelopemment, conseil, ...).' ,
  `remarques` VARCHAR(256) NULL COMMENT 'Remarques.' ,
  PRIMARY KEY (`idEntreprise`) ,
  INDEX `idGroupe` (`idGroupe` ASC) ,
  CONSTRAINT `idGroupe`
    FOREIGN KEY (`idGroupe` )
    REFERENCES `offreStage`.`Groupe` (`idGroupe` )
    ON DELETE SET NULL
    ON UPDATE CASCADE)
ENGINE = InnoDB, 
COMMENT = 'Liste des entreprises proposant des offres de stage.' ;


-- -----------------------------------------------------
-- Table `offreStage`.`Contact`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `offreStage`.`Contact` (
  `idContact` INT NOT NULL COMMENT 'Identifiant du contact.' ,
  `nom` VARCHAR(64) NOT NULL COMMENT 'Nom du contact.' ,
  `adresse` VARCHAR(256) NULL COMMENT 'Adresse du contact.' ,
  `codePostal` VARCHAR(32) NULL COMMENT 'Code postal.' ,
  `ville` VARCHAR(64) NULL COMMENT 'Ville.' ,
  `telephone` VARCHAR(32) NULL COMMENT 'NUméro de téléphone.' ,
  `fax` VARCHAR(32) NULL COMMENT 'NUméro de Fax.' ,
  `mail` VARCHAR(128) NULL COMMENT 'Adresse mail.' ,
  `remarques` VARCHAR(256) NULL COMMENT 'Remarques.' ,
  PRIMARY KEY (`idContact`) )
ENGINE = InnoDB, 
COMMENT = 'Liste des contacts pour des offres de stage.' ;


-- -----------------------------------------------------
-- Table `offreStage`.`RelationOffreEntreprise`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `offreStage`.`RelationOffreEntreprise` (
  `idRelationOffreEntreprise` INT NOT NULL COMMENT 'Identifiant de la relation Offre-Entreprise.' ,
  `idOffre` INT NOT NULL COMMENT 'Identifiant de l\'offre de stage.' ,
  `idEntreprise` INT NOT NULL COMMENT 'Identifiant de l\'entreprise.' ,
  `idType` INT NULL COMMENT 'Identifiant du type de la relation (voir table param).' ,
  `remarques` VARCHAR(256) NULL COMMENT 'Remarques.' ,
  PRIMARY KEY (`idRelationOffreEntreprise`) ,
  INDEX `idOffreROE` (`idOffre` ASC) ,
  INDEX `idEntrepriseROE` (`idEntreprise` ASC) ,
  INDEX `idTypeROE` (`idType` ASC) ,
  CONSTRAINT `idOffreROE`
    FOREIGN KEY (`idOffre` )
    REFERENCES `offreStage`.`Offre` (`idOffre` )
    ON DELETE NO ACTION
    ON UPDATE CASCADE,
  CONSTRAINT `idEntrepriseROE`
    FOREIGN KEY (`idEntreprise` )
    REFERENCES `offreStage`.`Entreprise` (`idEntreprise` )
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `idTypeROE`
    FOREIGN KEY (`idType` )
    REFERENCES `offreStage`.`Param` (`idParam` )
    ON DELETE SET NULL
    ON UPDATE CASCADE)
ENGINE = InnoDB, 
COMMENT = 'Association Offre-Entreprise.\nLe type d\'association est déte' /* comment truncated */ ;


-- -----------------------------------------------------
-- Table `offreStage`.`RelationOffreContact`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `offreStage`.`RelationOffreContact` (
  `idRelationOffreContact` INT NOT NULL COMMENT 'Identifiant de la relation Offre-Contact.' ,
  `idOffre` INT NOT NULL COMMENT 'Identifiant de l\'offre de stage.' ,
  `idContact` INT NOT NULL COMMENT 'Identifiant du contact.' ,
  `idType` INT NULL COMMENT 'Identifiant du type de la relation (voir table param).' ,
  `remarques` VARCHAR(256) NULL COMMENT 'Remarques.' ,
  PRIMARY KEY (`idRelationOffreContact`) ,
  INDEX `idOffreROC` (`idOffre` ASC) ,
  INDEX `idContactROC` (`idContact` ASC) ,
  INDEX `idTypeROC` (`idType` ASC) ,
  CONSTRAINT `idOffreROC`
    FOREIGN KEY (`idOffre` )
    REFERENCES `offreStage`.`Offre` (`idOffre` )
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `idContactROC`
    FOREIGN KEY (`idContact` )
    REFERENCES `offreStage`.`Contact` (`idContact` )
    ON DELETE NO ACTION
    ON UPDATE CASCADE,
  CONSTRAINT `idTypeROC`
    FOREIGN KEY (`idType` )
    REFERENCES `offreStage`.`Param` (`idParam` )
    ON DELETE SET NULL
    ON UPDATE CASCADE)
ENGINE = InnoDB, 
COMMENT = 'Association Offre-Contact.\nLe type d\'association est détermi' /* comment truncated */ ;


CREATE USER `SI_ISIMA` IDENTIFIED BY 'SI_ISIMA';


SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;

-- -----------------------------------------------------
-- Data for table `offreStage`.`Param`
-- -----------------------------------------------------
START TRANSACTION;
USE `offreStage`;
INSERT INTO `offreStage`.`Param` (`idParam`, `categorie`, `valeur`, `description`) VALUES (1, 'relationOffreEntreprise', 'Payeur', NULL);
INSERT INTO `offreStage`.`Param` (`idParam`, `categorie`, `valeur`, `description`) VALUES (2, 'relationOffreEntreprise', 'Client', NULL);
INSERT INTO `offreStage`.`Param` (`idParam`, `categorie`, `valeur`, `description`) VALUES (3, 'relationOffreEntreprise', 'Associé', NULL);
INSERT INTO `offreStage`.`Param` (`idParam`, `categorie`, `valeur`, `description`) VALUES (10, 'relationOffreContact', 'Contact', NULL);
INSERT INTO `offreStage`.`Param` (`idParam`, `categorie`, `valeur`, `description`) VALUES (11, 'relationOffreContact', 'Tuteur', NULL);
INSERT INTO `offreStage`.`Param` (`idParam`, `categorie`, `valeur`, `description`) VALUES (12, 'relationOffreContact', 'Responsable des stages', NULL);
INSERT INTO `offreStage`.`Param` (`idParam`, `categorie`, `valeur`, `description`) VALUES (20, 'devise', 'euro', NULL);
INSERT INTO `offreStage`.`Param` (`idParam`, `categorie`, `valeur`, `description`) VALUES (21, 'devise', 'yen', NULL);
INSERT INTO `offreStage`.`Param` (`idParam`, `categorie`, `valeur`, `description`) VALUES (22, 'devise', 'dollar', NULL);
INSERT INTO `offreStage`.`Param` (`idParam`, `categorie`, `valeur`, `description`) VALUES (23, 'devise', 'peso', NULL);
INSERT INTO `offreStage`.`Param` (`idParam`, `categorie`, `valeur`, `description`) VALUES (24, 'devise', 'livre sterling', NULL);
INSERT INTO `offreStage`.`Param` (`idParam`, `categorie`, `valeur`, `description`) VALUES (25, 'devise', 'autre', NULL);
INSERT INTO `offreStage`.`Param` (`idParam`, `categorie`, `valeur`, `description`) VALUES (13, 'relationOffreContact', 'Signataire convention', NULL);

COMMIT;

-- -----------------------------------------------------
-- Data for table `offreStage`.`Offre`
-- -----------------------------------------------------
START TRANSACTION;
USE `offreStage`;
INSERT INTO `offreStage`.`Offre` (`idOffre`, `dateDepot`, `annee`, `titre`, `description`, `realisation`, `dateDebut`, `duree`, `dureeHebdomadaire`, `horaires`, `remuneration`, `idDevise`, `avantages`, `laboratoire`, `prioritaire`, `disponible`, `dateFinDepot`, `raisonFinDepot`, `nombreSalaries`, `adresse`, `niveau`, `profil`, `service`, `remarques`) VALUES (1, '2011/11/11', 2012, 'Développement d\'outils transverses', 'Développement Web (PHP) pour outils de suivi de projets.', 'Application Web.', '2012/04/02', '6 mois', '35H', '9-12, 14-18', 800, 20, NULL, 0, 0, 1, NULL, NULL, NULL, '...', 'ZZ3', 'Dev.', NULL, NULL);
INSERT INTO `offreStage`.`Offre` (`idOffre`, `dateDepot`, `annee`, `titre`, `description`, `realisation`, `dateDebut`, `duree`, `dureeHebdomadaire`, `horaires`, `remuneration`, `idDevise`, `avantages`, `laboratoire`, `prioritaire`, `disponible`, `dateFinDepot`, `raisonFinDepot`, `nombreSalaries`, `adresse`, `niveau`, `profil`, `service`, `remarques`) VALUES (2, '2012/02/02', 2012, 'Une application de traitement numérique ', '...', '...', '2012/04/09', '5 mois', '35 heures', '9h-12h30 ; 14h - 17h30', 700, 20, NULL, 1, 0, 1, NULL, NULL, NULL, '...', 'ZZ2', 'F4', NULL, NULL);

COMMIT;

-- -----------------------------------------------------
-- Data for table `offreStage`.`Groupe`
-- -----------------------------------------------------
START TRANSACTION;
USE `offreStage`;
INSERT INTO `offreStage`.`Groupe` (`idGroupe`, `nom`, `adresse`, `codePostal`, `ville`, `siteWeb`, `description`, `nombreSalaries`, `type`, `domaine`, `remarques`) VALUES (1, 'Logica', '250 Brook Drive', 'Reading, RG2 6UA', ' Green Park', 'www.logica.com', '...', NULL, 'SSII', 'Informatique', 'Royaume-Uni');
INSERT INTO `offreStage`.`Groupe` (`idGroupe`, `nom`, `adresse`, `codePostal`, `ville`, `siteWeb`, `description`, `nombreSalaries`, `type`, `domaine`, `remarques`) VALUES (2, 'Michelin', '23 Place des Carmes Déchaux', '63040', 'Clermont-Ferrand', 'www.michelin.com', '...', NULL, 'Industrie', 'Pneumatique', NULL);

COMMIT;

-- -----------------------------------------------------
-- Data for table `offreStage`.`Entreprise`
-- -----------------------------------------------------
START TRANSACTION;
USE `offreStage`;
INSERT INTO `offreStage`.`Entreprise` (`idEntreprise`, `idGroupe`, `nom`, `adresse`, `codePostal`, `ville`, `codeAPENAF`, `siteWeb`, `description`, `nombreSalaries`, `type`, `domaine`, `remarques`) VALUES (1, 1, 'Logica Clermont', '...', '...', '...', NULL, '...', '...', NULL, NULL, NULL, NULL);
INSERT INTO `offreStage`.`Entreprise` (`idEntreprise`, `idGroupe`, `nom`, `adresse`, `codePostal`, `ville`, `codeAPENAF`, `siteWeb`, `description`, `nombreSalaries`, `type`, `domaine`, `remarques`) VALUES (2, 1, 'Logica Lyon', '...', '...', '...', NULL, '...', '...', NULL, NULL, NULL, NULL);
INSERT INTO `offreStage`.`Entreprise` (`idEntreprise`, `idGroupe`, `nom`, `adresse`, `codePostal`, `ville`, `codeAPENAF`, `siteWeb`, `description`, `nombreSalaries`, `type`, `domaine`, `remarques`) VALUES (3, 1, 'Logica Paris', '...', '...', '...', NULL, '...', '...', NULL, NULL, NULL, NULL);
INSERT INTO `offreStage`.`Entreprise` (`idEntreprise`, `idGroupe`, `nom`, `adresse`, `codePostal`, `ville`, `codeAPENAF`, `siteWeb`, `description`, `nombreSalaries`, `type`, `domaine`, `remarques`) VALUES (4, 2, 'Michelin Carmes', '...', '...', '...', NULL, '...', '...', NULL, NULL, NULL, NULL);
INSERT INTO `offreStage`.`Entreprise` (`idEntreprise`, `idGroupe`, `nom`, `adresse`, `codePostal`, `ville`, `codeAPENAF`, `siteWeb`, `description`, `nombreSalaries`, `type`, `domaine`, `remarques`) VALUES (5, NULL, 'CEA', 'Centre Le Ripault – DMAT/SDI/LEAT', 'BP 16 – 37260', 'Monts', NULL, NULL, NULL, NULL, NULL, NULL, NULL);

COMMIT;

-- -----------------------------------------------------
-- Data for table `offreStage`.`Contact`
-- -----------------------------------------------------
START TRANSACTION;
USE `offreStage`;
INSERT INTO `offreStage`.`Contact` (`idContact`, `nom`, `adresse`, `codePostal`, `ville`, `telephone`, `fax`, `mail`, `remarques`) VALUES (1, 'Valérie Boudot', '...', '...', '...', '...', '...', '...', NULL);
INSERT INTO `offreStage`.`Contact` (`idContact`, `nom`, `adresse`, `codePostal`, `ville`, `telephone`, `fax`, `mail`, `remarques`) VALUES (2, 'E.MONTERRAT', '...', '...', '...', '02.47.34.40.78', '', 'eric.monterrat@cea.fr ', NULL);
INSERT INTO `offreStage`.`Contact` (`idContact`, `nom`, `adresse`, `codePostal`, `ville`, `telephone`, `fax`, `mail`, `remarques`) VALUES (3, 'P. Hermet', '', '', '', '', '', NULL, NULL);

COMMIT;

-- -----------------------------------------------------
-- Data for table `offreStage`.`RelationOffreEntreprise`
-- -----------------------------------------------------
START TRANSACTION;
USE `offreStage`;
INSERT INTO `offreStage`.`RelationOffreEntreprise` (`idRelationOffreEntreprise`, `idOffre`, `idEntreprise`, `idType`, `remarques`) VALUES (1, 1, 1, 1, NULL);
INSERT INTO `offreStage`.`RelationOffreEntreprise` (`idRelationOffreEntreprise`, `idOffre`, `idEntreprise`, `idType`, `remarques`) VALUES (2, 1, 4, 2, NULL);
INSERT INTO `offreStage`.`RelationOffreEntreprise` (`idRelationOffreEntreprise`, `idOffre`, `idEntreprise`, `idType`, `remarques`) VALUES (3, 2, 5, 1, NULL);

COMMIT;

-- -----------------------------------------------------
-- Data for table `offreStage`.`RelationOffreContact`
-- -----------------------------------------------------
START TRANSACTION;
USE `offreStage`;
INSERT INTO `offreStage`.`RelationOffreContact` (`idRelationOffreContact`, `idOffre`, `idContact`, `idType`, `remarques`) VALUES (1, 1, 1, 10, NULL);
INSERT INTO `offreStage`.`RelationOffreContact` (`idRelationOffreContact`, `idOffre`, `idContact`, `idType`, `remarques`) VALUES (2, 1, 3, 11, NULL);
INSERT INTO `offreStage`.`RelationOffreContact` (`idRelationOffreContact`, `idOffre`, `idContact`, `idType`, `remarques`) VALUES (3, 2, 2, 10, NULL);

COMMIT;
